clear all

%Choose whether to enter a gating or fluorescence trace
    filetypeprompt={'Is this an ionic (i), gating (g) or fluorescence (f) trace?'};
    dlg_filetypetitle='File type';
    num_lines=1;
    default_filetype={'f'};
    filetype=inputdlg(filetypeprompt,dlg_filetypetitle,num_lines,default_filetype);

    
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%





%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
    
    
    %Electrophysiological plotting
    if strcmp(filetype, 'g')
        h4=msgbox('Please choose a gating current file.');
        oocyte1gate=datreader('d','a','g');
        delete(h4);
        promptgate= 'What is the gating group number?  ';
        gategroup=input(promptgate);
        gate=oocyte1gate.(['group' num2str(gategroup)]);
        acq_period=gate.acqrate;
        dur1=gate(1,1).dur(1);
        dur2=gate(1,1).dur(2);
        dur3=gate(1,1).dur(3);
        firstgatepulse=round(dur1/acq_period);
        secondgatepulse=round((dur1+dur2)/acq_period);
        thirdgatepulse=round((dur1+dur2+dur3)/acq_period);
        default_gate_prepulse= ((dur1)/1000);
        default_gate_pulse= ((dur1+dur2)/1000);
        default_gate_postpulse= ((dur1+dur2+dur3)/1000);
        gatebaselineprompt = {'Prepulse baseline time', 'Pulse baseline time', 'Postpulse baseline time'};
        dlg_gatetitle= 'Gating Baseline Parameters';
        num_lines=1;
        default_gate= {num2str(default_gate_prepulse),num2str(default_gate_pulse),num2str(default_gate_postpulse)};
        gateanswer=inputdlg(gatebaselineprompt,dlg_gatetitle,num_lines,default_gate);
        prepulse_baseline_time= round(str2double(gateanswer{1})*1000/acq_period);
        pulse_baseline_time= round(str2double(gateanswer{2})*1000/acq_period);
        postpulse_baseline_time= round(str2double(gateanswer{3})*1000/acq_period);
        prepulse_baseline_end=prepulse_baseline_time+50;
        pulse_baseline_end=pulse_baseline_time+50;
        postpulse_baseline_end=postpulse_baseline_time+50;
        [n,totsweep]=size(gate);
        cmap=jet(totsweep);
        set(0,'DefaultAxesColorOrder',cmap);
        gateaxis=[((dur1)/1000)-10 ((dur1+dur2+dur3)/1000)+10 -150 150];
        
        gatebase=zeros(8000,totsweep);
        
        for i=1:totsweep
            %baseline electrical recording
            gatebaseline1=mean(gate(i).data(prepulse_baseline_time:prepulse_baseline_end));
            gatebaseline2=mean(gate(i).data(pulse_baseline_time:pulse_baseline_end));
            gatebaseline3=mean(gate(i).data(postpulse_baseline_time:postpulse_baseline_end));
            gatebase(:,i)=cat(1, gate(i).data(1:firstgatepulse)-gatebaseline1, gate(i).data(firstgatepulse+1:secondgatepulse)-gatebaseline2, gate(i).data(secondgatepulse+1:end)-gatebaseline3);
            figure(1);

            plot(gate(i).time/1000,gatebase(:,i)*1000, 'Color', 'k');
            h1=figure(1);
            axis(gateaxis);
            
            hold on
        end
            ylabel(('Gating current (nA)'),'FontWeight','bold','FontSize',24,'FontName','Arial');
            xlabel('Time (ms)','FontWeight','bold','FontSize',24,'FontName','Arial');
            
            %title('Example Title','FontWeight','bold','FontSize',36,'FontName','Arial');
            xlim([20 90]);
            set(gca,'Xtick', [20 40 60 80], 'XTickLabel', {'0';'20';'40';'60'}, 'LineWidth',3,'FontWeight','bold', 'FontSize',24);
            set(gcf, 'Color',[1 1 1]);
            box off
        
        
        % Fluorescence plotting
    elseif strcmp(filetype,'f')
        h3=msgbox('Please choose a fluo file.');
        oocyte1fluo=datreader('d','a','g');
        delete(h3);
        promptfluo= 'What is the fluorescence group number?  ';
        fluogroup=input(promptfluo);
        fluo=oocyte1fluo.(['group' num2str(fluogroup)]);
        dur1=fluo(1,1).dur(1);
        dur2=fluo(1,1).dur(2);
        dur3=fluo(1,1).dur(3);
        acq_period=fluo.acqrate;
        Fs=1/(acq_period/1E6);
             
        %Fluorescence baseline parameters
        default_fluo_baseline_time1_begin = ((dur1)/1000)-6;
        default_fluo_baseline_time1_end = ((dur1)/1000)-1.5;
        default_fluo_baseline_time2_begin = ((dur1+dur2+dur3)/1000)-6;
        default_fluo_baseline_time2_end = ((dur1+dur2+dur3)/1000)-2;
        fluobaselineprompt = {'First fluo baseline time begin','First fluo baseline time end','Second fluo baseline time begin', 'Second fluo baseline time end'};
        dlg_fluotitle = 'Fluo Baseline Parameters';
        num_lines=1;
        default_fluo = {num2str(default_fluo_baseline_time1_begin), num2str(default_fluo_baseline_time1_end), num2str(default_fluo_baseline_time2_begin), num2str(default_fluo_baseline_time2_end)};
        fluoanswer=inputdlg(fluobaselineprompt,dlg_fluotitle,num_lines,default_fluo);
        first_fluo_baseline_begin= str2double(fluoanswer{1})*1000;
        first_fluo_baseline_end = str2double(fluoanswer{2})*1000;
        second_fluo_baseline_begin = str2double(fluoanswer{3})*1000;
        second_fluo_baseline_end = str2double(fluoanswer{4})*1000;
        
        %Initialize arrays
        [m,totsweep]=size(fluo);
        deltaF_array=zeros(8000,totsweep);
        outliers=zeros(8000,totsweep);
        baseline=zeros(8000,totsweep);
        filteredbaseline=zeros(8000,totsweep);
        Tau=zeros(2,totsweep);
        deltaF_amplitudemax=zeros(1,totsweep);
        deltaF_amplitudemean=zeros(1,totsweep);
        deltaF_slow=zeros(1,totsweep);
        start_fit=59;
        end_fit=139;
        start_fit=round(start_fit*1000/acq_period);
        end_fit=round(end_fit*1000/acq_period);
        start_fastamplitude=29;
        end_fastamplitude=31;

        start_slowamplitude=50;
        end_slowamplitude=59.5;
        start_slowamplitude=round(start_slowamplitude*1000/acq_period);
        end_slowamplitude=round(end_slowamplitude*1000/acq_period);
        end_fastamplitude=round(end_fastamplitude*1000/acq_period);
        start_fastamplitude=round(start_fastamplitude*1000/acq_period);
        
        
        cmap=jet(totsweep);
        set(0,'DefaultAxesColorOrder',cmap);
        fluoaxis=[((dur1)/1000)-10 ((dur1+dur2+dur3)/1000)+10 -1 1];
        
        promptfilter= 'What is the filter frequency in Hz?  ';
        Cutoff=input(promptfilter);
        [z,p,k]=besself(8,Cutoff);
        [zd,pd,kd]=bilinear(z,p,k,Fs);
        sos=zp2sos(zd,pd,kd);
        Hd=dfilt.df2tsos(sos);
        
        for i=1:totsweep
            %baseline fluorescence (exponential fit subtraction)
            outliers(:,i)=excludedata(fluo(i).time,fluo(i).data,'domain',[first_fluo_baseline_begin first_fluo_baseline_end]) & excludedata(fluo(i).time, fluo(i).data,'domain',[second_fluo_baseline_begin second_fluo_baseline_end]);
            fitobject=fit(fluo(i).time, fluo(i).data,'exp1', 'Exclude', outliers(:,i));
            baseline(:,i)=fluo(i).data-fitobject(fluo(i).time);
            
            %Filter fluorescence
            filteredbaseline(:,i)=filter(Hd,baseline(:,i));
            
            %Find deltaF/F
            Fo=mean(filteredbaseline(7500:8000,i));
            deltaF_array(:,i)=filteredbaseline(:,i)/abs(Fo);
            
            %Determine voltage for trace
            voltage=fluo(1,i).amp;
            thisvoltage=voltage(2,1);
            namevoltage=[num2str(thisvoltage) ' mV'];
            
            %%%Set colors%%%
            switch thisvoltage
            case -160
                linecolor=[122/255 16/255 228/255];
            %case -140
                
            case -120
                linecolor=[0 0 0];
            %case -100
                
            case -80
                linecolor=[0 0 255/255];
            %case -60
                
            case -40
                linecolor=[0 127/255 0];
            %case -20
                
            case 0
                linecolor= [222/255 125/255 0];
            %case 20
                
            case 40
                linecolor=[255/255 0 0];
            %case 60
                
            case 80 
                linecolor=[216/255 41/255 0];
                
            otherwise
             linecolor=[255/255 0 255/255];
            end            
            %%%%%%%%%%%%%%%
            
            %Plot fluorescence
            fluoplot=plot(fluo(1).time/1000, deltaF_array(:,i)*100, 'color', linecolor, 'LineWidth',2, 'DisplayName', namevoltage);
            axis(fluoaxis);
            ylabel('\Delta F/F_o (%)','FontWeight','bold','FontSize',24,'FontName','Arial');
            xlabel('Time (ms)','FontWeight','bold','FontSize',24,'FontName','Arial');
            title('Example Title','FontWeight','bold','FontSize',36,'FontName','Arial');
            xlim([20 90]);
            set(gca,'Xtick', [20 40 60 80], 'XTickLabel', {'0';'20';'40';'60'}, 'LineWidth',3,'FontWeight','bold', 'FontSize',24);
            set(gcf, 'Color',[1 1 1]);
            box off
            
            hold on
    
            %Fit fluorescent kinetics
            x=deltaF_array(start_fit:end_fit,i);
            y= fluo(i).time(start_fit:end_fit,1);
            [deltaFit,deltaFitCheck]=fit(x,y/1000,'exp1');
            Tau(:,i)=coeffvalues(deltaFit);
            dlg_filetypetitle  
            deltaF_amplitudemax(:,i)=max(deltaF_array(start_fastamplitude:end_fastamplitude,i));
            
            deltaF_amplitudemean(:,i)=mean(deltaF_array(start_slowamplitude:end_slowamplitude,i));
            deltaF_slow(:,i)=(deltaF_amplitudemax(:,i)-deltaF_amplitudemean(:,i))*100;
            
            
            %[deltaFit2,deltaFitCheck2]=fit(x,y/1000,'exp2')          
        end
    legend ('toggle');
    deltaF_slowandfast=vertcat(deltaF_slow,deltaF_amplitudemax*100);
    
    elseif strcmp(filetype,'i')
        h2=msgbox('Please choose an ionic current file.');
        oocyte1ionic=datreader('d','a','g');
        delete(h2);
        promptionic= 'What is the ionic group number?  ';
        ionicgroup=input(promptionic);
        ionic=oocyte1ionic.(['group' num2str(ionicgroup)]);
        acq_period=ionic.acqrate;
        dur1=ionic(1,1).dur(1);
        dur2=ionic(1,1).dur(2);
        dur3=ionic(1,1).dur(3);
        firstionicpulse=round(dur1/acq_period);
        secondionicpulse=round((dur1+dur2)/acq_period);
        thirdionicpulse=round((dur1+dur2+dur3)/acq_period);
        default_ionic_prepulse= ((dur1)/1000)-6;
        default_ionic_pulse= ((dur1+dur2)/1000)-6;
        default_ionic_postpulse= ((dur1+dur2+dur3)/1000)-8;
        ionicbaselineprompt = {'Baseline time'};
        dlg_ionictitle= 'Ionic Baseline Parameters';
        num_lines=1;
        default_ionic= {num2str(default_ionic_prepulse)};
        ionicanswer=inputdlg(ionicbaselineprompt,dlg_ionictitle,num_lines,default_ionic);
        prepulse_baseline_time= round(str2double(ionicanswer{1})*1000/acq_period);
        prepulse_baseline_end=prepulse_baseline_time+50;
        [n,totsweep]=size(ionic);
        set(0,'DefaultAxesColorOrder',cmap);
        ionicaxis=[((dur1)/1000)-10 ((dur1+dur2+dur3)/1000)+10 -1 1.5];
        
        ionicbase=zeros(8000,totsweep);
        
        for i=1:totsweep
            ionicbaseline=mean(gate(i).data(prepulse_baseline_time:prepulse_baseline_end));
            ionicbase(:,i)=ionic(i).data-gatebaseline1;
            figure(1);

            plot(ionic(i).time/1000,ionicbase(:,i), 'Color', 'k');
            h1=figure(1);
            axis(ionicaxis);
            ylabel('Ionic current (\mu A)');
            xlabel('Time (ms)');
            hold on
        end
    else
        warning('On', 'Not a valid filetype.')
    end